function PhantomSmokeGhostHexToRgb(t){if(Array.isArray(t))return t;if("string"!=typeof t||null==t||!t)return console.warn("PhantomSmokeGhost: Invalid color format, using default. Received:",t),[.98,.96,.96];let e=t.replace("#",""),i;if(3===e.length)i=e.split("").map(t=>t+t).join("");else if(6===e.length)i=e;else{if(8!==e.length)return console.warn(`PhantomSmokeGhost: Invalid hex color length "${t}", using default`),[.98,.96,.96];i=e.substring(0,6),console.log(`PhantomSmokeGhost: Using 8-digit hex "${t}", ignoring alpha channel`)}if(!/^[0-9A-Fa-f]{6}$/.test(i))return console.warn(`PhantomSmokeGhost: Invalid hex color "${t}", using default`),[.98,.96,.96];let s=parseInt(i.substring(0,2),16)/255,r=parseInt(i.substring(2,4),16)/255,o=parseInt(i.substring(4,6),16)/255;return[s,r,o]}class PhantomSmokeGhost{constructor(t,e={}){if(this.targetElement="string"==typeof t?document.querySelector(t):t,!this.targetElement){console.error("PhantomSmokeGhost: Target element not found");return}let i=e.id||Math.random().toString(36).substring(2,11);this.instanceId=i,this.canvasEl=this.createCanvas(),this.isMouseOverTarget=!1,this.mouseThreshold=.1,this.devicePixelRatio=Math.min(window.devicePixelRatio,2);let s=window.innerWidth||800,r=window.innerHeight||600;this.mouse={x:.25*s,y:.8*r,tX:.25*s,tY:.8*r,moving:!1,controlsPadding:0},this.params={size:.1,tail:{dotsNumber:25,spring:1.4,friction:.3,gravity:0},smile:1,mainColor:[.98,.96,.96],borderColor:[.2,.5,.7],...e},this.params.mainColor=PhantomSmokeGhostHexToRgb(this.params.mainColor),this.params.borderColor=PhantomSmokeGhostHexToRgb(this.params.borderColor),this.textureEl=document.createElement("canvas"),this.textureCtx=this.textureEl.getContext("2d"),this.pointerTrail=Array(this.params.tail.dotsNumber),this.dotSize=t=>{let e=window.innerHeight||600,i=isFinite(this.params.size)&&this.params.size>0?this.params.size:.1,s=this.params.tail.dotsNumber>0?this.params.tail.dotsNumber:25,r=i*e*(1-.2*Math.pow(3*t/s-1,2));return isFinite(r)&&r>0?r:10};for(let o=0;o<this.params.tail.dotsNumber;o++){let a=.04+.3*Math.pow(1-o/this.params.tail.dotsNumber,4),n=.6*Math.pow(1-o/this.params.tail.dotsNumber,1);this.pointerTrail[o]={x:this.mouse.x,y:this.mouse.y,vx:0,vy:0,opacity:isFinite(a)?a:.1,bordered:isFinite(n)?n:.6,r:this.dotSize(o)}}this.uniforms=null,this.gl=this.initShader(),this.movingTimer=null,this.isRunning=!1,this.animationId=null,this.fadeTimeout=null,this.init()}createCanvas(){let t=document.createElement("canvas");return t.id=`phantom-smoke-ghost-${this.instanceId}`,t.style.position="fixed",t.style.top="0",t.style.left="0",t.style.width="100vw",t.style.height="100vh",t.style.pointerEvents="none",t.style.zIndex="999999999",t.style.opacity="0",t.style.transition="opacity 400ms ease-in-out",t.style.display="none",document.body.appendChild(t),t}init(){this.boundResizeCanvas=this.resizeCanvas.bind(this),this.boundMouseMove=t=>{this.isMouseOverTarget&&this.updateMousePosition(t.clientX,t.clientY)},this.boundTouchMove=this.handleTouchMove.bind(this),this.boundClick=t=>{this.isMouseOverTarget&&this.updateMousePosition(t.clientX,t.clientY)},this.boundMouseEnter=this.handleMouseEnter.bind(this),this.boundMouseLeave=this.handleMouseLeave.bind(this),window.addEventListener("resize",this.boundResizeCanvas),this.targetElement.addEventListener("mouseenter",this.boundMouseEnter),this.targetElement.addEventListener("mouseleave",this.boundMouseLeave),this.resizeCanvas()}handleTouchMove(t){if(t.targetTouches&&t.targetTouches[0]&&this.isMouseOverTarget){let e=t.targetTouches[0];this.updateMousePosition(e.clientX,e.clientY)}}handleMouseEnter(){this.isMouseOverTarget=!0,this.start()}handleMouseLeave(){this.isMouseOverTarget=!1,this.stop()}start(){this.isRunning||(this.isRunning=!0,this.fadeTimeout&&(clearTimeout(this.fadeTimeout),this.fadeTimeout=null),this.canvasEl.style.display="block",this.canvasEl.offsetHeight,this.canvasEl.style.opacity="1",window.addEventListener("mousemove",this.boundMouseMove),window.addEventListener("touchmove",this.boundTouchMove),window.addEventListener("click",this.boundClick),this.render(),this.movingTimer=setTimeout(()=>this.mouse.moving=!1,300))}stop(){this.isRunning&&(this.isRunning=!1,window.removeEventListener("mousemove",this.boundMouseMove),window.removeEventListener("touchmove",this.boundTouchMove),window.removeEventListener("click",this.boundClick),this.canvasEl.style.opacity="0",this.fadeTimeout=setTimeout(()=>{this.isRunning||(this.canvasEl.style.display="none")},450),this.animationId&&(cancelAnimationFrame(this.animationId),this.animationId=null),this.movingTimer&&(clearTimeout(this.movingTimer),this.movingTimer=null))}updateMousePosition(t,e){let i=isFinite(t)?t:this.mouse.tX,s=isFinite(e)?e:this.mouse.tY;this.mouse.moving=!0,this.mouse.controlsPadding<0&&(this.mouse.moving=!1),clearTimeout(this.movingTimer),this.movingTimer=setTimeout(()=>{this.mouse.moving=!1},300),this.mouse.tX=i;let r=window.innerHeight||600,o=isFinite(this.params.size)?this.params.size:.1,a=o*r,n=s-.6*a;this.mouse.tY=n>a?n:a,this.mouse.tY-=this.mouse.controlsPadding}vertShader(){return`
        precision mediump float;

        varying vec2 vUv;
        attribute vec2 a_position;

        void main() {
            vUv = .5 * (a_position + 1.);
            gl_Position = vec4(a_position, 0.0, 1.0);
        }
        `}fragShader(){return`
        precision mediump float;

        varying vec2 vUv;
        uniform float u_time;
        uniform float u_ratio;
        uniform float u_size;
        uniform vec2 u_pointer;
        uniform float u_smile;
        uniform vec2 u_target_pointer;
        uniform vec3 u_main_color;
        uniform vec3 u_border_color;

        uniform sampler2D u_texture;

        #define TWO_PI 6.28318530718
        #define PI 3.14159265358979323846

        vec3 mod289(vec3 x) { return x - floor(x * (1.0 / 289.0)) * 289.0; }
        vec2 mod289(vec2 x) { return x - floor(x * (1.0 / 289.0)) * 289.0; }
        vec3 permute(vec3 x) { return mod289(((x*34.0)+1.0)*x); }
        float snoise(vec2 v) {
            const vec4 C = vec4(0.211324865405187, 0.366025403784439, -0.577350269189626, 0.024390243902439);
            vec2 i = floor(v + dot(v, C.yy));
            vec2 x0 = v - i + dot(i, C.xx);
            vec2 i1;
            i1 = (x0.x > x0.y) ? vec2(1.0, 0.0) : vec2(0.0, 1.0);
            vec4 x12 = x0.xyxy + C.xxzz;
            x12.xy -= i1;
            i = mod289(i);
            vec3 p = permute(permute(i.y + vec3(0.0, i1.y, 1.0)) + i.x + vec3(0.0, i1.x, 1.0));
            vec3 m = max(0.5 - vec3(dot(x0, x0), dot(x12.xy, x12.xy), dot(x12.zw, x12.zw)), 0.0);
            m = m*m;
            m = m*m;
            vec3 x = 2.0 * fract(p * C.www) - 1.0;
            vec3 h = abs(x) - 0.5;
            vec3 ox = floor(x + 0.5);
            vec3 a0 = x - ox;
            m *= 1.79284291400159 - 0.85373472095314 * (a0*a0 + h*h);
            vec3 g;
            g.x = a0.x * x0.x + h.x * x0.y;
            g.yz = a0.yz * x12.xz + h.yz * x12.yw;
            return 130.0 * dot(m, g);
        }
        vec2 rotate(vec2 v, float angle) {
            float r_sin = sin(angle);
            float r_cos = cos(angle);
            return vec2(v.x * r_cos - v.y * r_sin, v.x * r_sin + v.y * r_cos);
        }

        float eyes(vec2 uv) {
            uv.y -= .5;
            uv.x *= 1.;
            uv.y *= .8;
            uv.x = abs(uv.x);
            uv.y += u_smile * .3 * pow(uv.x, 1.3);
            uv.x -= (.6 + .2 * u_smile);

            float d = clamp(length(uv), 0., 1.);
            return 1. - pow(d, .08);
        }

        float mouth(vec2 uv) {
            uv.y += 1.5;

            uv.x *= (.5 + .5 * abs(1. - u_smile));
            uv.y *= (3. - 2. * abs(1. - u_smile));
            uv.y -= u_smile * 4. * pow(uv.x, 2.);

            float d = clamp(length(uv), 0., 1.);
            return 1. - pow(d, .07);
        }

        float face(vec2 uv, float rotation) {
            uv = rotate(uv, rotation);
            uv /= (.27 * u_size);

            float eyes_shape = 10. * eyes(uv);
            float mouth_shape = 20. * mouth(uv);

            float col = 0.;
            col = mix(col, 1., eyes_shape);
            col = mix(col, 1., mouth_shape);

            return col;
        }

        void main() {

            vec2 point = u_pointer;
            point.x *= u_ratio;

            vec2 uv = vUv;
            uv.x *= u_ratio;
            uv -= point;

            float texture = texture2D(u_texture, vec2(vUv.x, 1. - vUv.y)).r;
            float shape = texture;

            float noise = snoise(uv * vec2(.7 / u_size, .6 / u_size) + vec2(0., .0015 * u_time));
            noise += 1.2;
            noise *= 2.1;
            noise += smoothstep(-.8, -.2, (uv.y) / u_size);

            float face = face(uv, 5. * (u_target_pointer.x - u_pointer.x));
            shape -= face;

            shape *= noise;

            vec3 border = (1. - u_border_color);
            border.g += .2 * sin(.005 * u_time);
            border *= .5;

            vec3 color = u_main_color;
            color -= border * smoothstep(.0, .01, shape);

            shape = shape;
            color *= shape;

            gl_FragColor = vec4(color, shape);
        }`}initShader(){let t=this.vertShader(),e=this.fragShader(),i=this.canvasEl.getContext("webgl")||this.canvasEl.getContext("experimental-webgl");if(!i)return console.error("WebGL is not supported by your browser."),null;let s=(t,e,i)=>{let s=t.createShader(i);return(t.shaderSource(s,e),t.compileShader(s),t.getShaderParameter(s,t.COMPILE_STATUS))?s:(console.error("An error occurred compiling the shaders: "+t.getShaderInfoLog(s)),t.deleteShader(s),null)},r=s(i,t,i.VERTEX_SHADER),o=s(i,e,i.FRAGMENT_SHADER),a=((t,e,i)=>{let s=t.createProgram();return(t.attachShader(s,e),t.attachShader(s,i),t.linkProgram(s),t.getProgramParameter(s,t.LINK_STATUS))?s:(console.error("Unable to initialize the shader program: "+t.getProgramInfoLog(s)),null)})(i,r,o);this.uniforms=((t,e)=>{let i=[],s=t.getProgramParameter(e,t.ACTIVE_UNIFORMS);for(let r=0;r<s;r++){let o=t.getActiveUniform(e,r).name;i[o]=t.getUniformLocation(e,o)}return i})(i,a);let n=new Float32Array([-1,-1,1,-1,-1,1,1,1]),h=i.createBuffer();i.bindBuffer(i.ARRAY_BUFFER,h),i.bufferData(i.ARRAY_BUFFER,n,i.STATIC_DRAW),i.useProgram(a);let l=i.getAttribLocation(a,"a_position");i.enableVertexAttribArray(l),i.bindBuffer(i.ARRAY_BUFFER,h),i.vertexAttribPointer(l,2,i.FLOAT,!1,0,0);let u=i.createTexture();return i.bindTexture(i.TEXTURE_2D,u),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MIN_FILTER,i.LINEAR),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MAG_FILTER,i.LINEAR),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_S,i.CLAMP_TO_EDGE),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_T,i.CLAMP_TO_EDGE),i.texImage2D(i.TEXTURE_2D,0,i.RGBA,i.RGBA,i.UNSIGNED_BYTE,this.textureEl),i.uniform1i(this.uniforms.u_texture,0),i.uniform1f(this.uniforms.u_size,this.params.size),i.uniform3f(this.uniforms.u_main_color,this.params.mainColor[0],this.params.mainColor[1],this.params.mainColor[2]),i.uniform3f(this.uniforms.u_border_color,this.params.borderColor[0],this.params.borderColor[1],this.params.borderColor[2]),i}updateTexture(){this.textureCtx.fillStyle="black",this.textureCtx.fillRect(0,0,this.textureEl.width,this.textureEl.height),this.pointerTrail.forEach((t,e)=>{0===e?(t.x=this.mouse.x,t.y=this.mouse.y):(t.vx+=(this.pointerTrail[e-1].x-t.x)*this.params.tail.spring,t.vx*=this.params.tail.friction,t.vy+=(this.pointerTrail[e-1].y-t.y)*this.params.tail.spring,t.vy*=this.params.tail.friction,t.vy+=this.params.tail.gravity,t.x+=t.vx,t.y+=t.vy);let i=isFinite(t.x)?t.x:0,s=isFinite(t.y)?t.y:0,r=isFinite(t.r)&&t.r>0?t.r:1,o=isFinite(t.bordered)&&t.bordered>=0?r*t.bordered:0,a=this.textureCtx.createRadialGradient(i,s,Math.min(o,.9*r),i,s,r);a.addColorStop(0,"rgba(255, 255, 255, "+(isFinite(t.opacity)?t.opacity:.1)+")"),a.addColorStop(1,"rgba(255, 255, 255, 0)"),this.textureCtx.beginPath(),this.textureCtx.fillStyle=a,this.textureCtx.arc(i,s,r,0,2*Math.PI),this.textureCtx.fill()})}render(){if(!this.gl||!this.uniforms||!this.isRunning)return;let t=performance.now();this.gl.uniform1f(this.uniforms.u_time,t),this.gl.clearColor(0,0,0,1),this.gl.clear(this.gl.COLOR_BUFFER_BIT),this.gl.drawArrays(this.gl.TRIANGLE_STRIP,0,4),this.mouse.moving?(this.params.smile-=.05,this.params.smile=Math.max(this.params.smile,-.1),this.params.tail.gravity-=10*this.params.size,this.params.tail.gravity=Math.max(this.params.tail.gravity,0)):(this.params.smile+=.01,this.params.smile=Math.min(this.params.smile,1),this.params.tail.gravity>25*this.params.size?this.params.tail.gravity=(25+5*(1+Math.sin(.002*t)))*this.params.size:this.params.tail.gravity+=this.params.size),this.mouse.x+=(this.mouse.tX-this.mouse.x)*this.mouseThreshold,this.mouse.y+=(this.mouse.tY-this.mouse.y)*this.mouseThreshold;let e=window.innerWidth||800,i=window.innerHeight||600;this.gl.uniform1f(this.uniforms.u_smile,this.params.smile),this.gl.uniform2f(this.uniforms.u_pointer,this.mouse.x/e,1-this.mouse.y/i),this.gl.uniform2f(this.uniforms.u_target_pointer,this.mouse.tX/e,1-this.mouse.tY/i),this.gl.uniform3f(this.uniforms.u_main_color,this.params.mainColor[0],this.params.mainColor[1],this.params.mainColor[2]),this.gl.uniform3f(this.uniforms.u_border_color,this.params.borderColor[0],this.params.borderColor[1],this.params.borderColor[2]),this.updateTexture(),this.gl.texImage2D(this.gl.TEXTURE_2D,0,this.gl.RGBA,this.gl.RGBA,this.gl.UNSIGNED_BYTE,this.textureEl),this.isRunning&&(this.animationId=requestAnimationFrame(()=>this.render()))}resizeCanvas(){let t=window.innerWidth||800,e=window.innerHeight||600,i=isFinite(this.devicePixelRatio)&&this.devicePixelRatio>0?this.devicePixelRatio:1;if(this.canvasEl.width=t*i,this.canvasEl.height=e*i,this.textureEl.width=t,this.textureEl.height=e,this.gl&&this.uniforms){this.gl.viewport(0,0,this.canvasEl.width,this.canvasEl.height);let s=this.canvasEl.height>0?this.canvasEl.width/this.canvasEl.height:1;this.gl.uniform1f(this.uniforms.u_ratio,s)}for(let r=0;r<this.params.tail.dotsNumber;r++)this.pointerTrail[r]&&(this.pointerTrail[r].r=this.dotSize(r))}destroy(){this.stop(),this.fadeTimeout&&(clearTimeout(this.fadeTimeout),this.fadeTimeout=null),window.removeEventListener("resize",this.boundResizeCanvas),this.targetElement.removeEventListener("mouseenter",this.boundMouseEnter),this.targetElement.removeEventListener("mouseleave",this.boundMouseLeave),this.canvasEl&&this.canvasEl.parentNode&&this.canvasEl.parentNode.removeChild(this.canvasEl)}}if("undefined"!=typeof window){if("loading"===document.readyState)document.addEventListener("DOMContentLoaded",function(){let t=document.querySelector(".eael-ghost-cursor-trail");t&&(window.ghostTrail=new PhantomSmokeGhost("body"),window.ghostTrail.start())});else{let t=document.querySelector(".eael-ghost-cursor-trail");t&&(window.ghostTrail=new PhantomSmokeGhost("body"),window.ghostTrail.start())}}